unit AODrumulCMS1;

interface

uses Retea, Coada, Algoritm, Graphics;

type
    TAODrCMS= class(TAlgoritm)
                 d:array of integer;
               public
                 constructor Create(r:TRetea);
                 procedure fluxMaximStep;override;
                 procedure fluxMaximEnd;override;
                 procedure initializare;override;
                 function existaContinuare:boolean;override;
               private
                 x,y:integer;
                 procedure determinaEtDist();
                 procedure inaintare(var x:integer);
                 procedure inapoiere(var x:integer);
                 procedure marire;
                 function existaArcAdmisibil(x:integer):integer;
              end;
implementation

constructor TAODrCMS.Create(r:TRetea);
var n,i:integer;
begin
  retea:= r;
  n:= retea.getNrNoduri;
  SetLength(drum,n);
  SetLength(d,n);
  for i:=0 to high(drum) do
  begin
    d[i]:=0;
    drum[i]:= 0;
  end;
end;

procedure TAODrCMS.fluxMaximStep;
var s,t:integer;
begin
  s:= retea.nodSursa^.index;
  t:= retea.nodStoc^.index;
  y:=existaArcAdmisibil(x);
  if y<>0 then
  begin
    inaintare(x);
    if x=s then
    begin
      marire;
      x := t;
    end;
  end
  else
    inapoiere(x);
end;

procedure TAODrCMS.fluxMaximEnd;
var s,t,n:integer;
begin
  s:= retea.nodSursa^.index;
  t:= retea.nodStoc^.index;
  n:= retea.getNrNoduri;
  x:= t;
  while retea.nodStoc^.d<n do
  begin
    y:=existaArcAdmisibil(x);
    if y<>0 then
    begin
      inaintare(x);
      if x=s then
      begin
        marire;
        x:= t;
      end;
    end
    else
      inapoiere(x);
  end;
end;

procedure TAODrCMS.initializare;
begin
  determinaEtDist;
  x:= retea.nodStoc^.index;
end;

function TAODrCMS.existaContinuare:boolean;
begin
  result:= false;
  if retea.nodStoc^.d<retea.getNrNoduri then
    result:= true;
end;

procedure TAODrCMS.determinaEtDist;
var l:array of integer;
    v:TCoada;
    u:set of 1..255;
    i,s,x:integer;
    a:arc;
    p:nod;
begin
  i:= retea.getNrNoduri;
  SetLength(l,i);
  v:= TCoada.create;
  u:= [];
  for i:= 0 to high(l) do
  begin
    l[i]:=maxint;
    if (i+1)<>retea.nodSursa^.index then
      u:= u+[i+1];
  end;
  s:= retea.nodSursa^.index;
  l[s-1]:=0;
  v.adauga(s);
  while not v.goala do
  begin
    x:= v.extrage;
    a:= retea.listaArce;
    while a<>nil do
    begin
      if (a^.x=x)and(a^.r>0) then
        if (a^.y in u) then
        begin
          u:= u-[a^.y];
          v.adauga(a^.y);
          l[a^.y-1]:= l[x-1]+1;
        end;
      a:= a^.next;
    end;
  end;
  for i:= 0 to high(l) do
  begin
    p:= retea.getNod(i+1);
    p^.d:= l[i];
    d[i]:= l[i];
  end;
end;

procedure TAODrCMS.inaintare(var x:integer);
begin
  drum[y-1]:= x;
  x:= y;
end;

procedure TAODrCMS.inapoiere(var x:integer);
var a:arc;
    dx:integer;
    q:nod;
begin
  dx:= maxint;
  a:= retea.listaArce;
  while a<>nil do
  begin
    if (a^.r>0)and(a^.y=x) then
    begin
      q:= retea.getNod(a^.x);
      if (dx>q^.d) then
        dx:= q^.d;
    end;
    a:= a^.next;
  end;
  q:= retea.getNod(x);
  if dx<>maxint then
    q^.d:= dx+1
  else
    q^.d:= retea.getNrNoduri;
  if x<>retea.nodStoc^.index then
    x:= drum[x-1];
  q:= retea.listaNoduri;
  while q<>nil do
  begin
    d[q^.index-1]:= q^.d;
    q:= q^.next;
  end;
end;

procedure TAODrCMS.marire;
var x,cr:integer;
    a:arc;
begin
  cr:= maxInt;
  x:= retea.nodSursa^.index;
  while x<>retea.nodStoc^.index do
  begin
    a:= retea.getArc(x,drum[x-1]);
    if (a^.r>0)and(a^.r<cr) then
      cr:= a^.r;
    x:= drum[x-1];
  end;
  x:= retea.nodSursa^.index;
  while x<>retea.nodStoc^.index do
  begin
    a:= retea.getArc(x,drum[x-1]);
    a^.r:= a^.r-cr;
    a:= retea.getArc(drum[x-1],x);
    if a=nil then
    begin
      retea.adaugaArc(drum[x-1],x);
      retea.modificaArc(drum[x-1],x,0,cr,1);
    end
    else
      a^.r:= a^.r+cr;
    x:= drum[x-1];
  end;
end;


function TAODrCMS.existaArcAdmisibil(x:integer):integer;
var a:arc;
    p,q:nod;
begin
  result:=0;
  a:= retea.listaArce;
  while a<>nil do
    if (a^.y=x)and(a^.r>0) then
    begin
      p:= retea.getNod(a^.x);
      q:= retea.getNod(x);
      if q^.d=p^.d+1 then
      begin
        result:= a^.x;
        a:= nil;
      end
      else
        a:= a^.next
    end
    else
      a:= a^.next;
end;

end.
