unit AOReteleStratif1;

interface

uses Retea, Algoritm;

type
    TAORetStratif= class(TAlgoritm)
                      d,b:array of integer;
                    public
                      constructor Create(r:TRetea);
                      procedure fluxMaximStep;override;
                      procedure fluxMaximEnd;override;
                      procedure initializare;override;
                      function existaContinuare:boolean;override;
                    private
                      x,y:integer;
                      procedure inaintare(var x:integer;y:integer);
                      procedure inapoiere(var x:integer);
                      procedure micsorare;
                      procedure determinaEtDist();
                      function existaArcAdmisibil(x:integer):integer;
                   end;
implementation

uses Coada;

constructor TAORetStratif.Create(r:TRetea);
var n:integer;
begin
  retea:= r;
  n:= retea.getNrNoduri;
  setLength(d,n);
  setLength(b,n);
  setLength(drum,n);
end;

procedure TAORetStratif.fluxMaximStep;
var i,s,t,n:integer;
begin
  n:= retea.getNrNoduri;
  s:= retea.nodSursa^.index;
  t:= retea.nodStoc^.index;
  if b[t-1]=1 then
  begin
    y:=existaArcAdmisibil(x);
    if y<>0 then
    begin
      inaintare(x,y);
      if x=s then
      begin
        micsorare;
        x:= t;
      end;
    end
    else
      inapoiere(x);
  end
  else
  begin
    determinaEtDist;
    for i:= 0 to n-1 do
      b[i]:= 1;
    x:= t;
  end;
end;

procedure TAORetStratif.fluxMaximEnd;
var i,s,t,n:integer;
begin
  n:= retea.getNrNoduri;
  for i:= 0 to n-1 do
    b[i]:= 1;
  s:= retea.nodSursa^.index;
  t:= retea.nodStoc^.index;
  while retea.nodStoc^.d<n do
    if b[t-1]=1 then
    begin
      y:=existaArcAdmisibil(x);
      if y<>0 then
      begin
        inaintare(x,y);
        if x=s then
        begin
          micsorare;
          x:= t;
        end;
      end
      else
        inapoiere(x);
    end
    else
    begin
      determinaEtDist;
      for i:= 0 to n-1 do
        b[i]:= 1;
      x:= t;
    end;
end;

procedure TAORetStratif.initializare;
begin
  determinaEtDist;
  x:= retea.nodStoc^.index;
end;

function TAORetStratif.existaContinuare:boolean;
begin
  result:= false;
  if retea.nodStoc^.d<retea.getNrNoduri then
    result:= true;
end;

procedure TAORetStratif.inaintare(var x:integer; y:integer);
begin
  drum[y-1]:= x;
  x:= y;
end;

procedure TAORetStratif.inapoiere(var x:integer);
begin
  b[x-1]:= 0;
  if x<>retea.nodStoc^.index then
    x:= drum[x-1];
end;

procedure TAORetStratif.micsorare;
var x,cr:integer;
    a:arc;
begin
  cr:= maxInt;
  x:= retea.nodSursa^.index;
  while x<>retea.nodStoc^.index do
  begin
    a:= retea.getArc(x,drum[x-1]);
    if (a^.r>0)and(a^.r<cr) then
      cr:= a^.r;
    x:= drum[x-1];
  end;

  x:= retea.nodSursa^.index;
  while x<>retea.nodStoc^.index do
  begin
    a:= retea.getArc(x,drum[x-1]);
    a^.r:= a^.r-cr;
    a:= retea.getArc(drum[x-1],x);
    if a=nil then
    begin
      retea.adaugaArc(drum[x-1],x);
      retea.modificaArc(drum[x-1],x,0,cr,1);
    end
    else
      a^.r:= a^.r+cr;
    x:= drum[x-1];
  end;
end;


procedure TAORetStratif.determinaEtDist;
var l:array of integer;
    v:TCoada;
    u:set of 1..255;
    i,s,x:integer;
    a:arc;
    p:nod;
begin
  i:= retea.getNrNoduri;
  SetLength(l,i);
  v:= TCoada.create;
  u:= [];
  for i:= 0 to high(l) do
  begin
    l[i]:=maxint;
    if (i+1)<>retea.nodSursa^.index then
      u:= u+[i+1];
  end;
  s:= retea.nodSursa^.index;
  l[s-1]:=0;
  v.adauga(s);
  while not v.goala do
  begin
    x:= v.extrage;
    a:= retea.listaArce;
    while a<>nil do
    begin
      if (a^.x=x)and(a^.r>0) then
        if (a^.y in u) then
        begin
          u:= u-[a^.y];
          v.adauga(a^.y);
          l[a^.y-1]:= l[x-1]+1;
        end;
      a:= a^.next;
    end;
  end;
  for i:= 0 to high(l) do
  begin
    p:= retea.getNod(i+1);
    p^.d:= l[i];
    d[i]:= l[i];
  end;
end;

function TAORetStratif.existaArcAdmisibil(x:integer):integer;
var a:arc;
    p,q:nod;
begin
  result:=0;
  a:= retea.listaArce;
  while a<>nil do
    if (a^.y=x)and(a^.r>0) then
    begin
      p:= retea.getNod(a^.x);
      q:= retea.getNod(x);
      if (q^.d=p^.d+1)and(b[a^.x-1]=1) then
      begin
        result:= a^.x;
        a:= nil;
      end
      else
        a:= a^.next
    end
    else
      a:= a^.next;
end;

end.

