unit AOScalMaxCap;
interface

uses Retea, Algoritm, Graphics, Coada;

type
  TAOScMxCap= class(TAlgoritm)
                cb,rb:integer;
                l:array of integer;
                w:set of 1..255;
               public
                 constructor Create(r:TRetea);
                 procedure fluxMaximStep;override;
                 procedure fluxMaximEnd;override;
                 procedure initializare;override;
                 function existaContinuare:boolean; override;
               private
                 function cap_max:integer;
                 function existaDrum:boolean;
                 function capRezMin:integer;
              end;

implementation

uses Math;

constructor TAOScMxCap.Create(r:TRetea);
var n:integer;
begin
  retea:= r;
  cb:= cap_max();
  rb:= trunc(power(2,trunc(log2(cb))));
  n:= retea.getNrNoduri;
  setLength(drum,n);
  setLength(l,n);
end;

procedure TAOScMxCap.fluxMaximStep;
var cr,x:integer;
    a:arc;
begin
  if existaDrum then
  begin
    cr:= capRezMin;
    x:= retea.nodStoc^.index;
    while x<>retea.nodSursa^.index do
    begin
      a:= retea.getArc(drum[x-1],x);
      a^.r:= a^.r-cr;
      a:= retea.getArc(x,drum[x-1]);
      if a=nil then
      begin
        retea.adaugaArc(x,drum[x-1]);
        retea.modificaArc(x,drum[x-1],0,cr,1);
      end
      else
        a^.r:= a^.r+cr;
      x:= drum[x-1];
    end;
  end
  else
  rb:= rb div 2;
end;

procedure TAOScMxCap.fluxMaximEnd;
var cr,x:integer;
    a:arc;
begin
  while rb>1 do
  begin
    while existaDrum do
    begin
      cr:= capRezMin;
      x:= retea.nodStoc^.index;
      while x<>retea.nodSursa^.index do
      begin
        a:= retea.getArc(drum[x-1],x);
        a^.r:= a^.r-cr;
        a:= retea.getArc(x,drum[x-1]);
        if a=nil then
        begin
          retea.adaugaArc(x,drum[x-1]);
          retea.modificaArc(x,drum[x-1],0,cr,1);
        end
        else
          a^.r:= a^.r+cr;
        x:= drum[x-1];
      end;
    end;
    rb:= rb div 2;
  end;
end;

function TAOScMxCap.existaContinuare:boolean;
begin
  result:= false;
  if (rb>=1) then
    result:= true;
end;

function TAOScMxCap.cap_max:integer;
var a:arc;
begin
  result:= 0;
  a:= retea.listaArce;
  while a<>nil do
  begin
    if a^.c>result then
      result:= a^.c;
    a:= a^.next;
  end;
end;

function TAOScMxCap.existaDrum:boolean;
var v:TCoada;
    u:set of 1..255;
    i,s,t,x:integer;
    a:arc;
begin
  for x:=0 to high(drum) do
    drum[x]:= 0;
  result:=false;
  v:= TCoada.create;
  u:= [];
  w:= [];
  for i:= 0 to high(drum) do
  begin
    drum[i]:=0;
    l[i]:=maxint;
    if (i+1)<>retea.nodSursa^.index then
      u:= u+[i+1];
  end;
  s:= retea.nodSursa^.index;
  t:= retea.nodStoc^.index;
  l[s-1]:=0;
  v.adauga(s);
  while not v.goala do
  begin
    x:= v.extrage;
    a:= retea.listaArce;
    while a<>nil do
    begin
      if (a^.x=x)and(a^.r>0) then
        if (a^.y in u) then
        begin
          u:= u-[a^.y];
          v.adauga(a^.y);
          drum[a^.y-1]:= x;
          l[a^.y-1]:= l[x-1]+1;
        end;
      a:= a^.next;
    end;
    w:= w+[x];
  end;
  if t in w then
    result:= true;
end;

function TAOScMxCap.capRezMin:integer;
var a:arc;
    x:integer;
begin
  result:= maxInt;
  x:= retea.nodStoc^.index;
  while x<>retea.nodSursa^.index do
  begin
    a:= retea.getArc(drum[x-1],x);
    if (a^.r>0)and(a^.r<result) then
      result:= a^.r;
    x:= drum[x-1];
  end;
end;

procedure TAOScMxCap.initializare;
begin
end;

end.
