unit DinicRetStratif1;

interface

uses Retea, Algoritm, Graphics;

type
  TDinicRS= class(TAlgoritm)
               rstratif: TRetea;
               db:array of integer;
             public
               constructor Create(r:TRetea);
               procedure fluxMaximStep;override;
               procedure fluxMaximEnd;override;
               procedure initializare;override;
               function existaContinuare:boolean;override;
             private
               procedure reteaStratificata;
               procedure fluxBlocare;
               procedure marireFlux;
               procedure determinaEtCompl;
               function determinaDrum:boolean;
            end;

implementation

uses Coada, Math;

constructor TDinicRS.Create(r:TRetea);
var i,n:integer;
begin
  retea:= r;
  n:= retea.getNrNoduri;
  setLength(db,n);
  setLength(drum,n);
  for i:= 0 to n-1 do
  begin
    db[i]:= 0;
    drum[i]:= 0;
  end;
end;

procedure TDinicRS.fluxMaximStep;
begin
  reteaStratificata;
  fluxBlocare;
  marireFlux;
end;

procedure TDinicRS.fluxMaximEnd;
var t:integer;
begin
  t:= retea.nodStoc^.index;
  db[t-1]:= 0;
  while db[t-1]<retea.getNrNoduri do
  begin
    reteaStratificata;
    fluxBlocare;
    marireFlux;
  end;
end;

procedure TDinicRS.initializare;
begin
  db[retea.nodSursa^.index-1]:= 0;
end;

function TDinicRS.existaContinuare:boolean;
begin
  result:= false;
  if db[retea.nodSursa^.index-1]<retea.getNrNoduri then
    result:= true;
end;

procedure TDinicRS.reteaStratificata;
var a:arc;
    p:nod;
begin
  //se determina etichetele distanta complementara db
  determinaEtCompl;
  //se construieste reteaua stratificata
  rStratif.Free;
  rStratif := TRetea.Create;
  a:= retea.listaArce;
  while a<>nil do
  begin
    rstratif.adaugaArc(a^.x,a^.y,a^.l,a^.c,a^.f,a^.r);
    a:= a^.next;
  end;
  p:= retea.listaNoduri;
  while p<>nil do
  begin
    rstratif.adaugaNod(p^.x,p^.y,p^.index,p^.d,p^.e);
    p:= p^.next;
  end;
  new(rStratif.nodSursa);
  rStratif.nodSursa^.index:= retea.nodSursa^.index;
  new(rStratif.nodStoc);
  rStratif.nodStoc^.index:= retea.nodStoc^.index;
  a:= rStratif.listaArce;
  while (a<>nil) do
  begin
    if (db[a^.y-1] <> db[a^.x-1]+1) then
      rStratif.stergeArc(a);
    a:= a^.next;
  end;
end;

procedure TDinicRS.fluxBlocare;
var a:arc;
    cr,x:integer;
begin
  a:= rStratif.listaArce;
  while a<>nil do
  begin
    a^.f:= 0;
    a:= a^.next;
  end;
  while determinaDrum do
  begin
    //Se determina capacitatea reziduala minima a drumului gasit anterior
    cr:= maxInt;
    x:= rStratif.nodSursa^.index;
    while x<>rStratif.nodStoc^.index do
    begin
      a:= rStratif.getArc(x,drum[x-1]);
      if (a^.r>0)and(a^.r<cr) then
        cr:= a^.r;
      x:= drum[x-1];
    end;
    //Se executa marirea de flux cu capacitatea reziduala minima cr
    x:= rStratif.nodSursa^.index;
    while x<>rStratif.nodStoc^.index do
    begin
      a:= rStratif.getArc(x,drum[x-1]);
      a^.r:= max(a^.r-cr,0);
      a^.f:= a^.f+cr;
      a:= rStratif.getArc(drum[x-1],x);
      if a=nil then
      begin
        rStratif.adaugaArc(drum[x-1],x);
        a:= rStratif.getArc(drum[x-1],x);
      end;
      a^.r:= a^.r+cr;
      a^.f:= max(a^.f-cr,0);
      x:= drum[x-1];
    end;
  end;
end;

procedure TDinicRS.marireFlux;
var a,b:arc;
begin
  a:= rStratif.listaArce;
  while a<>nil do
  begin
    b:= retea.getArc(a^.x,a^.y);
    b^.f:= max(b^.f+a^.f,b^.l);
    a:= a^.next;
  end;
  retea.makeReteaReziduala;
  determinaEtCompl;
end;

procedure TDinicRS.determinaEtCompl;
var v:TCoada;
    u:set of 1..255;
    i,s,x:integer;
    a:arc;
begin
  v:= TCoada.create;
  u:= [];
  for i:= 0 to high(db) do
  begin
    db[i]:=maxint;
    if (i+1)<>retea.nodSursa^.index then
      u:= u+[i+1];
  end;
  s:= retea.nodSursa^.index;
  db[s-1]:=0;
  v.adauga(s);
  while not v.goala do
  begin
    x:= v.extrage;
    a:= retea.listaArce;
    while a<>nil do
    begin
      if (a^.x=x)and(a^.r>0) then
        if (a^.y in u) then
        begin
          u:= u-[a^.y];
          v.adauga(a^.y);
          db[a^.y-1]:= db[x-1]+1;
        end;
      a:= a^.next;
    end;
  end;
end;

function TDinicRS.determinaDrum:boolean;
var v:TCoada;
    u,w:set of 1..255;
    i,t,x:integer;
    a:arc;
begin
  result:= false;
  v:= TCoada.create;
  u:= [];
  w:= [];
  for i:= 0 to high(drum) do
  begin
    drum[i]:=0;
    if (i+1)<>rStratif.nodStoc^.index then
      u:= u+[i+1];
  end;
  t:= rStratif.nodStoc^.index;
  v.adauga(t);
  while not v.goala do
  begin
    x:= v.extrage;
    w:= w+[x];
    a:= rStratif.listaArce;
    while a<>nil do
    begin
      if (a^.y=x)and(a^.r>0) then
        if (a^.x in u) then
        begin
          u:= u-[a^.x];
          v.adauga(a^.x);
          drum[a^.x-1]:=x;
        end;
      a:= a^.next;
    end;
  end;
  if rStratif.nodSursa^.index in w then
    result:= true;
end;

end.
