unit EdmondsKarp;

interface

uses Coada, Graphics, Algoritm,  Windows, Messages, SysUtils, Classes, Controls,
  Dialogs, ExtCtrls, ToolWin, ComCtrls,
  StdCtrls, Retea;

type
  TEdmondsKarp= class(TAlgoritm)
                  e:array of integer;
                public
                  constructor Create(r:TRetea);
                  procedure fluxMaximStep;override;
                  procedure fluxMaximEnd;override;
                  function existaContinuare:boolean;override;
                  procedure initializare;override;
                private
                  procedure marire;
               end;
implementation

constructor TEdmondsKarp.Create(r:Tretea);
var n,i:integer;
begin
  retea:= r;
  n:= retea.getNrNoduri;
  setLength(drum,n);
  setLength(e,n);
  for i:= 0 to n-1 do
  begin
    e[i]:= 0;
    drum[i]:= 0;
  end;
end;

procedure TEdmondsKarp.fluxMaximStep;
var s,t,i,x:integer;
    a:arc;
    v:TCoada;
begin
  s:= retea.nodSursa^.index;
  t:= retea.nodStoc^.index;
  v:= TCoada.create;
  for i:=0 to high(e) do
  begin
    drum[i]:= 0;
    e[i]:= 0;
  end;
  e[s-1]:= 1;
  v.goleste;
  v.adauga(s);
  while (not v.goala)and(e[t-1]=0) do
  begin
    x:= v.extrage;
    a:= retea.listaArce;
    while a<>nil do
    begin
      if (a^.x=x)and(a^.r>0) then
        if e[a^.y-1]=0 then
        begin
          drum[a^.y-1]:= x;
          e[a^.y-1]:= 1;
          v.adauga(a^.y);
        end;
      a:= a^.next;
    end;
  end;
  if e[t-1]=1 then
    marire;
end;

procedure TEdmondsKarp.fluxMaximEnd;
var s,t,i,x:integer;
    a:arc;
    v:TCoada;
begin
  s:= retea.nodSursa^.index;
  t:= retea.nodStoc^.index;
  v:= TCoada.create;
  while e[t-1]=1 do
  begin
    for i:=0 to high(e) do
    begin
      drum[i]:= 0;
      e[i]:= 0;
    end;
    e[s-1]:= 1;
    v.goleste;
    v.adauga(s);
    while (not v.goala)and(e[t-1]=0) do
    begin
      x:= v.extrage;
      a:= retea.listaArce;
      while a<>nil do
      begin
        if (a^.x=x)and(a^.r>0) then
          if e[a^.y-1]=0 then
          begin
            drum[a^.y-1]:= x;
            e[a^.y-1]:= 1;
            v.adauga(a^.y);
          end;
        a:= a^.next;
      end;
    end;
    if e[t-1]=1 then
      marire;
  end;
end;

procedure TEdmondsKarp.initializare;
begin
  e[retea.nodStoc^.index-1]:= 1;
end;

function TEdmondsKarp.existaContinuare:boolean;
begin
  result:= false;
  if e[retea.nodStoc^.index-1]=1 then
    result:= true;
end;

procedure TEdmondsKarp.marire;
var x,cr:integer;
    a:arc;
begin
  cr:= maxInt;
  x:= retea.nodStoc^.index;
  while x<>retea.nodSursa^.index do
  begin
    a:= retea.getArc(drum[x-1],x);
    if (a^.r>0)and(a^.r<cr) then
      cr:= a^.r;
    x:= drum[x-1];
  end;
  x:= retea.nodStoc^.index;
  while x<>retea.nodSursa^.index do
  begin
    a:= retea.getArc(drum[x-1],x);
    a^.r:= a^.r-cr;
    a:= retea.getArc(x,drum[x-1]);
    if a=nil then
    begin
      retea.adaugaArc(x,drum[x-1]);
      retea.modificaArc(x,drum[x-1],0,cr,1);
    end
    else
      a^.r:= a^.r+cr;
    x:= drum[x-1];
  end;
end;

end.
