unit FFulkerson;

interface
uses Retea, Algoritm, Graphics;
type
  TFFulkerson= class(TAlgoritm)
                 e:array of integer;
                 v:set of 1..255;
                public
                  constructor Create(r:TRetea);
                  procedure fluxMaximStep;override;
                  procedure fluxMaximEnd;override;
                  procedure initializare; override;
                  function existaContinuare:boolean;override;
                private
                  function alegeNod:integer;
                  procedure marire;
              end;
implementation

uses Math;


constructor TFFulkerson.Create(r:TRetea);
var n,i:integer;
begin
  retea:= r;
  v:= [];
  n:= retea.getNrNoduri;
  setLength(drum,n);
  setLength(e,n);
  for i:= 0 to n-1 do
  begin
    e[i]:= 0;
    drum[i]:= 0;
  end;
end;

procedure TFFulkerson.fluxMaximStep;
var s,t,i,x:integer;
    a:arc;
begin
  s:= retea.nodSursa^.index;
  t:= retea.nodStoc^.index;
  for i:=0 to high(e) do
  begin
     drum[i]:= 0;
     e[i]:= 0;
  end;
  e[s-1]:= 1;
  v:= [s];
  while (v<>[])and(e[t-1]=0) do
  begin
    x:= alegeNod;
    a:= retea.listaArce;
    while a<>nil do
    begin
      if (a^.x=x)and(a^.r>0) then
        if e[a^.y-1]=0 then
        begin
          drum[a^.y-1]:= x;
          e[a^.y-1]:= 1;
          v:= v+[a^.y];
        end;
      a:= a^.next;
    end;
  end;
  if e[t-1]=1 then
    marire;
end;

procedure TFFulkerson.fluxMaximEnd;
var s,t,i,x:integer;
    a:arc;
begin
  s:= retea.nodSursa^.index;
  t:= retea.nodStoc^.index;
  while e[t-1]=1 do
  begin
    for i:=0 to high(e) do
    begin
      drum[i]:= 0;
      e[i]:= 0;
    end;
    e[s-1]:= 1;
    v:= [s];
    while (v<>[])and(e[t-1]=0) do
    begin
      x:= alegeNod;
      a:= retea.listaArce;
      while a<>nil do
      begin
        if (a^.x=x)and(a^.r>0) then
          if e[a^.y-1]=0 then
          begin
            drum[a^.y-1]:= x;
            e[a^.y-1]:= 1;
            v:= v+[a^.y];
          end;
        a:= a^.next;
      end;
    end;
    if e[t-1]=1 then
      marire;
  end;
end;

procedure TFFulkerson.initializare;
begin
  e[retea.nodStoc^.index-1]:= 1;
end;

function TFFulkerson.existaContinuare:boolean;
begin
  result:= false;
  if e[retea.nodStoc^.index-1]=1 then
    result:= true;
end;

function TFFulkerson.alegeNod:integer;
var i,n:integer;
begin
  result:=0;
  n:= retea.getNrNoduri;
  for i:= 1 to n do
    if i in v then
    begin
      result:= i;
      v:= v-[i];
      break;
    end;
end;

procedure TFFulkerson.marire;
var x,cr:integer;
    a:arc;
begin
  cr:= maxInt;
  x:= retea.nodStoc^.index;
  while x<>retea.nodSursa^.index do
  begin
    a:= retea.getArc(drum[x-1],x);
    if (a^.r>0)and(a^.r<cr) then
      cr:= a^.r;
    x:= drum[x-1];
  end;

  x:= retea.nodStoc^.index;
  while x<>retea.nodSursa^.index do
  begin
    a:= retea.getArc(drum[x-1],x);
    a^.r:= a^.r-cr;
    a:= retea.getArc(x,drum[x-1]);
    if a=nil then
    begin
      retea.adaugaArc(x,drum[x-1]);
      retea.modificaArc(x,drum[x-1],0,cr,1);
    end
    else
      a^.r:= a^.r+cr;
    x:= drum[x-1];
  end;
end;

end.
