unit GabowScalCap;

interface

uses Retea, Algoritm;

type
  TGabow= class(TAlgoritm)
            private
              c:array of array of integer;
              k:integer;
            public
              constructor Create(r:TRetea);
              procedure fluxMaximStep;override;
              procedure fluxMaximEnd;override;
              procedure initializare;override;
              function existaContinuare:boolean;override;
          end;

implementation
uses Math, Generic1;

constructor TGabow.Create(r:TRetea);
begin
  retea:= r;
end;

procedure TGabow.fluxMaximStep;
var i:integer;
    a:arc;
    G:TGeneric;
begin
//  initializare;
  if k>=0 then
  begin
    a:= retea.listaArce;
    i:=0;
    while a<>nil do
    begin
      a^.c:= c[k,i];
      a^.f:= 2*a^.f;
      a^.r:= 0;
      a:= a^.next;
      i:= i+1;
    end;
    retea.makeReteaReziduala;
    G:= TGeneric.Create(retea);
    G.fluxMaximEnd;
    retea.makeReteaNereziduala;
    retea.makeReteaReziduala;
    G.Free;
    k:= k-1;
  end;
end;

procedure TGabow.fluxMaximEnd;
var i:integer;
    a:arc;
    G:TGeneric;
begin
//  initializare;
  while k>=0 do
  begin
    a:= retea.listaArce;
    i:=0;
    while a<>nil do
    begin
      a^.c:= c[k,i];
      a^.f:= 2*a^.f;
      a^.r:= 0;
      a:= a^.next;
      i:= i+1;
    end;
    retea.makeReteaReziduala;
    G:= TGeneric.Create(retea);
    G.fluxMaximEnd;
    retea.makeReteaNereziduala;
    retea.makeReteaReziduala;
    G.Free;
    k:= k-1;
  end;
end;

procedure TGabow.initializare;
var dim,cbar,cmax,n,i,j:integer;
    a:arc;
begin
//Se determina c barat= capacitatea maxima din retea
  a:= retea.listaArce;
  while a<>nil do
  begin
    a^.f:= 0;
    a:= a^.next;
  end;
  cbar:= 0;
  a:= retea.listaArce;
  while a<>nil do
  begin
    if a^.c>cbar then
      cbar:= a^.c;
    a:= a^.next;
  end;
  dim:= trunc(log2(cbar))+1;
  n:= retea.getNrArce;

  setLength(c,dim);
  for i:= 0 to dim-1 do
  begin
    setLength(c[i],n);
    for j:= 0 to n-1 do
      c[i,j]:= 0;
  end;

  k:= 0;
  a:= retea.listaArce;
  for i:= 0 to n-1 do
  begin
    c[k,i]:= a^.c;
    a:= a^.next;
  end;
  cmax:= 0;
  for i:=0 to n-1 do
    if (cmax < c[k,i]) then
      cmax:= c[k,i];
  while cmax>1 do
  begin
    for i:= 0 to n-1 do
      c[k+1,i]:= c[k,i] div 2;
    k:= k+1;
    cmax:= 0;
    for i:=0 to n-1 do
      if (cmax < c[k,i]) then
        cmax:= c[k,i];
  end;
  a:= retea.listaArce;
  while a<>nil do
  begin
    a^.f:= 0;
    a:= a^.next;
  end;
end;

function TGabow.existaContinuare:boolean;
begin
  result:= true;
end;

end.
