unit Generic1;

interface

uses Math,Retea, Algoritm, Graphics;

type
  TGeneric= class(TAlgoritm)
             public
               constructor Create(r:TRetea);
               procedure fluxMaximStep;override;
               procedure fluxMaximEnd;override;
               procedure initializare;override;
               function existaContinuare:boolean;override;
             private
               function existaDrum:boolean;
               function capRezMin:integer;
            end;
implementation

uses Coada;

constructor TGeneric.Create(r:TRetea);
var n:integer;
begin
  retea:= r;
  n:= retea.getNrNoduri;
  setLength(drum,n);
end;

procedure TGeneric.fluxMaximStep;
var cr,x:integer;
    a:arc;
begin
  cr:= capRezMin;
  x:= retea.nodStoc^.index;
  while x<>retea.nodSursa^.index do
  begin
    a:= retea.getArc(drum[x-1],x);
    a^.r:= max(a^.r-cr,0);
    a:= retea.getArc(x,drum[x-1]);
    if a=nil then
    begin
      retea.adaugaArc(x,drum[x-1]);
      a := retea.getArc(x, drum[x-1]);
    end;
    a^.r:= a^.r+cr;
    x:= drum[x-1];
  end;
end;

procedure TGeneric.fluxMaximEnd;
var cr,x:integer;
    a:arc;
begin
  while existaDrum do
  begin
    cr:= capRezMin;
    x:= retea.nodStoc^.index;
    while x<>retea.nodSursa^.index do
    begin
      a:= retea.getArc(drum[x-1],x);
      a^.r:= a^.r-cr;
      a:= retea.getArc(x,drum[x-1]);
      if a=nil then
      begin
        retea.adaugaArc(x,drum[x-1]);
        a:= retea.getArc(x,drum[x-1]);
      end;
      a^.r:= a^.r+cr;
      x:= drum[x-1];
    end;
  end;
end;

procedure TGeneric.initializare;
begin
end;

function TGeneric.existaContinuare:boolean;
begin
  result:= false;
  if existaDrum then
    result:= true;
end;

function TGeneric.existaDrum:boolean;
var v:Tcoada;
    u,w:set of 1..255;
    i,s,t,x:integer;
    a:arc;
begin
  for x:=0 to high(drum) do
    drum[x]:= 0;
  result:=false;
  v:= TCoada.create;
  u:= [];
  w:= [];
  for i:= 0 to high(drum) do
  begin
    drum[i]:=0;
    if (i+1)<>retea.nodSursa^.index then
      u:= u+[i+1];
  end;
  s:= retea.nodSursa^.index;
  t:= retea.nodStoc^.index;
  v.adauga(s);
  while not v.goala do
  begin
    x:= v.extrage;
    a:= retea.listaArce;
    while a<>nil do
    begin
      if (a^.x=x)and(a^.r>0) then
        if (a^.y in u) then
        begin
          u:= u-[a^.y];
          v.adauga(a^.y);
          drum[a^.y-1]:= x;
        end;
      a:= a^.next;
    end;
    w:= w+[x];
  end;
  if t in w then
    result:= true;
end;

function TGeneric.capRezMin:integer;
var a:arc;
    x:integer;
begin
  result:= maxInt;
  x:= retea.nodStoc^.index;
  while x<>retea.nodSursa^.index do
  begin
    a:= retea.getArc(drum[x-1],x);
    if (a^.r>0)and(a^.r<result) then
      result:= a^.r;
    x:= drum[x-1];
  end;
end;

end.
