unit PrefluxFIFOTS;

interface

uses Retea, Coada, Algoritm, Graphics;

type
  TPrefFIFO= class(TAlgoritm)
               L:TCoada;
             public
               constructor Create(r:Tretea);
               procedure fluxMaximStep;override;
               procedure fluxMaximEnd;override;
               procedure initializare;override;
               function existaContinuare:boolean;override;
             private
               x:integer;
               procedure reetichetare(x:integer);
               procedure determinaEtExacte;
               procedure inainteazaUnitflux(j,i,val:integer);
               function admisibil(x,y:integer):boolean;
            end;

implementation

uses Math;

constructor TPrefFifo.Create(r:Tretea);
var p:nod;
begin
  retea:= r;
  L:= TCoada.create;
  p:= retea.listaNoduri;
  while p<>nil do
  begin
    p^.e:= 0;
    p:= p^.next;
  end;
end;

procedure TPrefFifo.fluxMaximStep;
begin
  x:= L.extrage;
  reetichetare(x);
end;

procedure TPrefFifo.fluxMaximEnd;
begin
  if retea.nodStoc^.d<=retea.getNrNoduri then
    while not L.goala do
    begin
      x:= L.extrage;
      reetichetare(x);
    end;
end;

function TPrefFIFO.existaContinuare:boolean;
begin
  result:= false;
  if retea.nodStoc^.d<=retea.getNrNoduri then
    if not L.goala then
      result:= true;
end;

procedure TPrefFIFO.initializare;
var a:arc;
    t:integer;
begin
  determinaEtExacte;
  t:= retea.nodStoc^.index;
  a:= retea.listaArce;
  while a<>nil do
  begin
    if (a^.y=t)and(a^.r>0) then
    begin
      a^.f:= a^.l;
      inainteazaUnitFlux(t,a^.x,a^.r);
      if (retea.getNod(a^.x)^.e<0)and(a^.x<>retea.nodSursa^.index) then
        L.adauga(a^.x);
    end;
    a:= a^.next;
  end;
  retea.nodStoc^.d:= retea.getNrNoduri;
end;

procedure TPrefFIFO.reetichetare(x:integer);
var a:arc;
    p:nod;
    yaux,y,dx:integer;
    b:boolean;
begin
  y:= -1;
  a:= retea.listaArce;
  while a<>nil do
    if (a^.y=x)and(a^.r>0) then
    begin
      y:= a^.x;
      a:= nil;
    end
    else
      a:= a^.next;
  b:= true;
  repeat
    if admisibil(y,x) then
    begin
      inainteazaUnitFlux(x,y,min(-retea.getNod(x)^.e,retea.getArc(y,x)^.r));
      if (not l.cauta(y))and(y<>retea.nodStoc^.index)and(y<>retea.nodSursa^.index) then
        l.adauga(y);
    end;
    if retea.getNod(x)^.e<0 then
    begin
      yaux:= y;
      y:= -1;
      a:= retea.getArc(yaux,x)^.next;
      while a<>nil do
        if (a^.y=x)and(a^.r>0) then
          begin
            y:= a^.x;
            a:= nil;
          end
        else
          a:= a^.next;
      if y=-1 then
      begin
        dx:= maxint;
        a:= retea.listaArce;
        while a<>nil do
        begin
          if (a^.r>0)and(a^.y=x) then
          begin
            p:= retea.getNod(a^.x);
            if (dx>p^.d) then
              dx:= p^.d;
          end;
          a:= a^.next;
        end;
        p:= retea.getNod(x);
        if dx<>maxint then
          p^.d:= dx+1;
        b:= false;
      end;
    end;
  until (retea.getNod(x)^.e=0)or(b=false);
  if retea.getNod(x)^.e<0 then
    L.adauga(x);
end;

procedure TPrefFIFO.determinaEtExacte;
var ld:array of integer;
    v:TCoada;
    u:set of 1..255;
    i,s,x:integer;
    a:arc;
    p:nod;
begin
  i:= retea.getNrNoduri;
  SetLength(ld,i);
  v:= TCoada.create;
  u:= [];
  for i:= 0 to high(ld) do
  begin
    ld[i]:=maxint;
    if (i+1)<>retea.nodSursa^.index then
      u:= u+[i+1];
  end;
  s:= retea.nodSursa^.index;
  ld[s-1]:=0;
  v.adauga(s);
  while not v.goala do
  begin
    x:= v.extrage;
    a:= retea.listaArce;
    while a<>nil do
    begin
      if (a^.x=x)and(a^.r>0) then
        if (a^.y in u) then
        begin
          u:= u-[a^.y];
          v.adauga(a^.y);
          ld[a^.y-1]:= ld[x-1]+1;
        end;
      a:= a^.next;
    end;
  end;
  for i:= 0 to high(ld) do
  begin
    p:= retea.getNod(i+1);
    p^.d:= ld[i];
  end;
end;

procedure TPrefFIFO.inainteazaUnitflux(j,i,val:integer);
var a:arc;
begin
  a:= retea.getArc(j,i);
  if a<>nil then
  begin
    a^.r:= a^.r+val;
    a:= retea.getArc(i,j);
    if a=nil then
    begin
      retea.adaugaArc(i,j);
      retea.modificaArc(i,j,0,0,1);
    end
    else
      a^.r:= max(a^.r-val,0);
  end;
  retea.getNod(i)^.e:= retea.getNod(i)^.e-val;
  retea.getNod(j)^.e:= retea.getNod(j)^.e+val;
end;

function TPrefFIFO.admisibil(x,y:integer):boolean;
begin
  result:= false;
  if (retea.getNod(y)^.d=retea.getNod(x)^.d+1)then
    result:= true;
end;

end.


