unit PrefluxGenericTS;

interface

uses Retea, Algoritm, Graphics;

type
  TPrefGen= class(TAlgoritm)
               d:array of integer;
             public
               constructor Create(r:Tretea);
               procedure fluxMaximStep;override;
               procedure fluxMaximEnd;override;
               procedure initializare; override;
               function existaContinuare:boolean;override;
             private
               x:integer;
               procedure determinaEtDist;
               procedure inaintare(var x:integer);
               function selectareNodActiv(var x:integer):boolean;
               procedure inainteazaUnitFlux(j,i,val:integer);
               function existaArcAdmisibil(j:integer):integer;
            end;

implementation

uses Coada, Math;

constructor TPrefGen.Create(r:Tretea);
var n,i:integer;
begin
  retea:= r;
  n:= retea.getNrNoduri;
  setlength(d,n);
  for i:= 0 to n-1 do
    d[i]:= 0;
end;

procedure TPrefGen.fluxMaximStep;
begin
  inaintare(x);
end;

procedure TPrefGen.fluxMaximEnd;
begin
  if retea.nodStoc^.d<=retea.getNrNoduri then
    while selectareNodActiv(x) do
      inaintare(x);
end;

procedure TPrefGen.determinaEtDist;
var l:array of integer;
    v:TCoada;
    u:set of 1..255;
    i,s,x:integer;
    a:arc;
    p:nod;
begin
  i:= retea.getNrNoduri;
  SetLength(l,i);
  v:= TCoada.create;
  u:= [];
  for i:= 0 to high(l) do
  begin
    l[i]:=maxint;
    if (i+1)<>retea.nodSursa^.index then
      u:= u+[i+1];
  end;
  s:= retea.nodSursa^.index;
  l[s-1]:=0;
  v.adauga(s);
  while not v.goala do
  begin
    x:= v.extrage;
    a:= retea.listaArce;
    while a<>nil do
    begin
      if (a^.x=x)and(a^.r>0) then
        if (a^.y in u) then
        begin
          u:= u-[a^.y];
          v.adauga(a^.y);
          l[a^.y-1]:= l[x-1]+1;
        end;
      a:= a^.next;
    end;
  end;
  for i:= 0 to high(l) do
  begin
    p:= retea.getNod(i+1);
    p^.d:= l[i];
    d[i]:= l[i];
  end;
end;

procedure TPrefGen.initializare;
var a:arc;
    t:integer;
    p:nod;
begin
  determinaEtDist;
  p:= retea.listaNoduri;
  while p<>nil do
  begin
    p^.e:= 0;
    p:= p^.next;
  end;
  a:= retea.listaArce;
  t:= retea.nodStoc^.index;
  while a<>nil do
  begin
    if (a^.y=t)and(a^.r>0) then
    begin
      a^.f:= a^.l;
      inainteazaUnitFlux(t,a^.x,a^.r);
    end;
    a:= a^.next;
  end;
  retea.nodStoc^.d:= retea.getNrNoduri;
end;

function TPrefGen.existaContinuare:boolean;
begin
  result:= false;
  if retea.nodStoc^.d<=retea.getNrNoduri then
    if selectareNodActiv(x) then
      result:= true;
end;

procedure TPrefGen.inaintare(var x:integer);
var y,dx:integer;
    a: arc;
    p:nod;
begin
  p:= retea.listaNoduri;
  while p<>nil do
  begin
    d[p^.index-1]:= p^.e;
    p:= p^.next;
  end;
  y:= existaArcAdmisibil(x);
  if y<>0 then
  begin
    a:= retea.getArc(y,x);
    inainteazaUnitFlux(x,y,min(-retea.getNod(x)^.e,a^.r));
  end
  else
  begin
    dx:= maxint;
    a:= retea.listaArce;
    while a<>nil do
    begin
      if (a^.r>0)and(a^.y=x) then
      begin
        p:= retea.getNod(a^.x);
        if (dx>p^.d) then
          dx:= p^.d;
      end;
      a:= a^.next;
    end;
    p:= retea.getNod(x);
    if dx<>maxint then
      p^.d:= dx+1;
  end;
end;

function TPrefGen.selectareNodActiv(var x:integer):boolean;
var p:nod;
begin
  result:= false;
  p:= retea.listaNoduri;
  while p<>nil do
    if (p^.e<0)and(p^.index<>retea.nodSursa^.index)and(p^.index<>retea.nodStoc^.index) then
    begin
      result:= true;
      x:= p^.index;
      p:= nil;
    end
    else
      p:= p^.next;
end;

procedure TPrefGen.inainteazaUnitFlux(j,i,val:integer);
var a:arc;
begin
  a:= retea.getArc(j,i);
  if a<>nil then
  begin
    a^.r:= a^.r+val;
    a:= retea.getArc(i,j);
    if a=nil then
    begin
      retea.adaugaArc(i,j);
      retea.modificaArc(i,j,0,0,1);
    end
    else
      a^.r:= max(a^.r-val,0);
  end;
  retea.getNod(i)^.e:= retea.getNod(i)^.e-val;
  retea.getNod(j)^.e:= retea.getNod(j)^.e+val;
end;

function TPrefGen.existaArcAdmisibil(j:integer):integer;
var a:arc;
    p,q:nod;
begin
  result:=0;
  a:= retea.listaArce;
  while a<>nil do
    if (a^.y=j)and(a^.r>0) then
    begin
      p:= retea.getNod(a^.x);
      q:= retea.getNod(j);
      if q^.d=p^.d+1 then
      begin
        result:= a^.x;
        a:= nil;
      end
      else
        a:= a^.next
    end
    else
      a:= a^.next;
end;

end.
