unit ProiectAOC;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, ReprezentareRetea, Retea, ExtCtrls, Menus, ToolWin, ComCtrls, ActnList, ImgList,
  StdCtrls, Buttons, Algoritm, TeEngine, Series, TeeProcs, Chart,UDespreAplic;

type
  TFrmMain = class(TForm)
    mainMenu1: TMainMenu;
    retea1: TMenuItem;
    setari1: TMenuItem;
    imageList1: TImageList;
    toolBar: TToolBar;
    tbNew: TToolButton;
    tbOpen: TToolButton;
    tbSave: TToolButton;
    toolButton5: TToolButton;
    openDialog1: TOpenDialog;
    saveDialog1: TSaveDialog;
    open1: TMenuItem;
    save1: TMenuItem;
    popupMenu1: TPopupMenu;
    setNodSursa: TMenuItem;
    setNodStoc: TMenuItem;
    popupMenu2: TPopupMenu;
    sterge1: TMenuItem;
    modifica1: TMenuItem;
    toolButton1: TToolButton;
    stergeNod: TMenuItem;
    n2: TMenuItem;
    exit1: TMenuItem;
    afiseazaLegenda1: TMenuItem;
    afisareArce1: TMenuItem;
    afisareNoduri1: TMenuItem;
    show1: TMenuItem;
    reteaReziduala1: TMenuItem;
    reteaNereziduala1: TMenuItem;
    capacitate2: TMenuItem;
    valoareNod1: TMenuItem;
    etichetaDistanta1: TMenuItem;
    excesul1: TMenuItem;
    image2: TImage;
    label1: TLabel;
    image1: TImage;
    saveAs1: TMenuItem;
    Algoritmi1: TMenuItem;
    Algoritmulgenericpseudopolinomial1: TMenuItem;
    AlgoritmulFordFulkersondeetichetare1: TMenuItem;
    AlgoritmulGabowalscalariibitacapacitatii1: TMenuItem;
    AlgoritmulAhujaOrlinalscalariimaximeacapacitatii1: TMenuItem;
    AlgoritmulEdmondsKarpaldrumuluicelmaiscurt1: TMenuItem;
    AlgoritmulAhujaOrlinaldrumuluicelmaiscurt1: TMenuItem;
    AlgoritmulDinicalretelelorstratificate1: TMenuItem;
    AlgoritmulAhujaOrlinalretelelorstratificate1: TMenuItem;
    Algoritmulprefluxgeneric1: TMenuItem;
    AlgoritmulprefluxFIFO1: TMenuItem;
    tbFlux: TToolButton;
    tbRez: TToolButton;
    tbNext: TToolButton;
    tbEnd: TToolButton;
    Des1: TMenuItem;
    procedure New1Click(Sender: TObject);
    procedure Image1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Open1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure SetNodSursaClick(Sender: TObject);
    procedure Stergenod1Click(Sender: TObject);
    procedure Sterge1Click(Sender: TObject);
    procedure Modifica1Click(Sender: TObject);
    procedure Retea1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FordFulkersonClick(Sender: TObject);
    procedure genericClick(Sender: TObject);
    procedure AhujaOrlinScalarClick(
      Sender: TObject);
    procedure EdmondsKarpClick(Sender: TObject);
    procedure AhujaOrlinDrumClick(Sender: TObject);
    procedure AhujaOrlinReteleClick(Sender: TObject);
    procedure SetNodStocClick(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure afiseazalegenda1Click(Sender: TObject);
    procedure Valoarenod1Click(Sender: TObject);
    procedure Etichetadistanta1Click(Sender: TObject);
    procedure Excesul1Click(Sender: TObject);
    procedure Capacitate2Click(Sender: TObject);
    procedure PrefluxGenericClick(Sender: TObject);
    procedure PrefluxFIFOClick(Sender: TObject);
    procedure DinicClick(Sender: TObject);
    procedure GabowClick(Sender: TObject);
    procedure Saveas1Click(Sender: TObject);
    procedure tbRezClick(Sender: TObject);
    procedure tbFluxClick(Sender: TObject);
    procedure tbNextClick(Sender: TObject);
    procedure tbEndClick(Sender: TObject);
    procedure Des1Click(Sender: TObject);
  private
    f:Text;
    alg:TAlgoritm;
    s,fisier:string;
    procedure selectieNod(p:nod);
    procedure selectieArc(a:arc);
    function pozValida(x,y:integer):boolean;
    function reteaValida:boolean;
    procedure openArcDialog(a:arc);
    procedure openRetea(numefis:string);
    procedure saveRetea(numefis:string);
    procedure enableFluxMaxim(val:boolean);
    procedure legenda(val:boolean);
    procedure updateLegenda;
  public
    n:integer;
    r:TReprezentare;
    procedure clearImage;
    function getInt(x:boolean):integer;
    function getBoolean(x:integer):boolean;
    function drumValid(drum:array of integer):boolean;
  end;
var
  frmMain: TfrmMain;
  aux:nod;
  arcAux:arc;
  keyD:word;
  alg:TAlgoritm;
implementation

uses arcDialog, OptiuniRetea, FFulkerson, Generic1,
      AOScalMaxCap, EdmondsKarp, AODrumulCMS1, AOReteleStratif1,
      PrefluxGenericTS, PrefluxFIFOTS, DinicRetStratif1, GabowScalCap;

{$R *.DFM}

procedure TfrmMain.clearImage;
begin
  image1.Canvas.Pen.Color:=clWhite;
  image1.Canvas.Rectangle(0,0,image1.width,image1.height);
  image1.Canvas.Pen.Color:=clBlack;
end;

procedure TfrmMain.New1Click(Sender: TObject);
begin
  fisier:= '';
  frmMain.Enabled:=false;
  optiuniForm.visible:=true;
  if image2.Visible then
    updateLegenda;
end;

procedure TfrmMain.Image1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var s:string;
    p:nod;
begin
 r.desenRetea(image1.canvas,image1.width,image1.height);
 if (Button=mbLeft) then
 begin
   if (r.existaNod(x,y)) then
     if aux<>nil then
     begin
       p:=r.getNod(x,y);
       if p<>aux then
       begin
         if r.existaArc(aux,p) then
         begin
           arcAux:=r.getArc(aux,p);
           selectieArc(arcAux);
           popupMenu2.Popup(p^.x+frmMain.left+image1.left+10,p^.y+frmMain.top+image1.top+45);
         end
         else
           if keyD=VK_CONTROL then
           begin
             r.adaugaArc(aux^.index,p^.index);
             arcAux:=r.getArc(aux,p);
             openArcDialog(arcAux);
             keyD:=0;
           end;
       end
       else
       begin
         r.mutaNod(p,x,y);
         r.desenRetea(image1.canvas,image1.width,image1.height);
       end;
       aux:=nil;
     end
     else
     begin
       aux:=r.getNod(x,y);
       selectieNod(aux);
     end
   else
   begin
     if (r.nodValid(x,y))and(pozValida(x,y)) then
       if aux<>nil then
       begin
         r.mutaNod(aux,x,y);
         r.desenRetea(image1.canvas,image1.width,image1.height);
       end
       else
         if keyD=VK_CONTROL then
         begin
           n:=n+1;
           str(n,s);
           r.AdaugaNod(n,x,y);
           r.desenNod(n,x,y,clBlack,image1.Canvas);
           keyD:=0;
         end;
    aux:=nil;
   end
  end
  else
    if (Button=mbRight) then
      if r.existaNod(x,y) then
      begin
        aux:=r.getNod(x,y);
        if r.nodSursa<>nil then
          popupmenu1.Items[0].Enabled:=false
        else
          popupmenu1.Items[0].Enabled:=true;
        if r.nodStoc<>nil then
          popupmenu1.Items[1].Enabled:=false
        else
          popupmenu1.Items[1].Enabled:=true;
        popupmenu1.Popup(x+frmMain.left+image1.left+10,y+frmMain.top+image1.top+45);
      end
      else
        aux:= nil;
end;

function TfrmMain.pozValida(x,y:integer):boolean;
begin
 result:=true;
 if((x<2)or(x>image1.Width-20)or(y<2)or(y>image1.Height-20)) then
  result:=false;
end;

procedure TfrmMain.selectieNod(p:nod);
begin
 r.desenNod(p,clRed,image1.canvas);
end;

procedure TfrmMain.selectieArc(a:arc);
begin
 r.desenArc(a^.x,a^.y,clBlue,image1.canvas);
 r.desenNod(r.getNod(a.x),clblack,image1.canvas);
 r.desenNod(r.getNod(a.y),clblack,image1.canvas);
end;

procedure TfrmMain.openArcDialog(a:arc);
var s:string;
begin
  with arcForm do
  begin
    str(a^.x,s);
    primulN.Text:=s;
    str(a^.y,s);
    aldoileaN.Text:=s;
    str(a^.l,s);
    limitaInf.Text:=s;
    str(a^.c,s);
    capacitate.Text:=s;
    str(a^.f,s);
    fluxul.Text:=s;
    str(a^.r,s);
    capRezid.Text:=s;
    limitaInf.Enabled:=true;
    capacitate.Enabled:=true;
    if r.rezid then
      begin
        fluxul.Enabled:=false;
        caprezid.Enabled:=true;
      end
    else
      begin
        capRezid.Enabled:=false;
        fluxul.Enabled:=true
      end;
    frmMain.Enabled:=false;
    top:=frmMain.top+image1.top+r.getNod(a^.y)^.y+10;
    left:=frmMain.Left+image1.left+r.getNod(a^.y)^.x+45;
    Visible:=true;
  end;
end;

procedure TfrmMain.openRetea(numefis:string);
var nr,i,l,c,fl,d,e,x,y:integer;
    s:string;
begin
  assignFile(f,numefis);
  reset(f);
  readln(f,s);
  if upperCase(s)='RETEA' then
    begin
      image1.Enabled:=true;
      image1.Canvas.Pen.Color:=ClWhite;
      image1.Canvas.Rectangle(0,0,image1.width,image1.height);
      image1.Canvas.Pen.Color:=ClBlack;
      r.Free;
      r:=TReprezentare.Create;
      readln(f,x,y);
      r.limit:= true;
      r.cap:= true;
      Capacitate2.Checked:= true;
      r.exces:= false;
      Excesul1.Checked:= false;
      r.val:= false;
      Valoarenod1.Checked:= false;
      r.dist:= false;
      Etichetadistanta1.Checked:= false;
      r.flux:=getBoolean(x);
      r.rezid:=getBoolean(y);
      if r.rezid then
        begin
          reteareziduala1.Enabled:= false;
          tbRez.Enabled := false;
          tbFlux.Enabled := true;
          reteanereziduala1.Enabled:= true;
          enablefluxmaxim(true);
        end
      else
        begin
          reteareziduala1.Enabled:= true;
          reteanereziduala1.Enabled:= false;
          tbRez.Enabled := true;
          tbFlux.Enabled := false;
          enablefluxmaxim(false);
        end;
      readln(f,nr);
      n:=nr;
      for i:=1 to nr do
      begin
        readln(f,c,x,y,d,e);
        r.adaugaNod(c,x,y,d,e);
      end;
      readln(f,x,y);
      if x<>0 then
        r.nodSursa:= r.getNod(x);
      if y<>0 then
        r.nodStoc:= r.getNod(y);
      while not eof(f) do
      begin
        readln(f,x,y,l,c,fl,d);
        r.adaugaArc(x,y,l,c,fl,d);
      end;
      r.desenRetea(image1.canvas,image1.width,image1.Height);
    end
  else
    ShowMessage('Fisier necorespunzator');
  closeFile(f);
end;

procedure TfrmMain.saveRetea(numefis:string);
var a:arc;
    p:nod;
begin
  assignFile(f,numefis);
  rewrite(f);
  writeln(f,'RETEA');
  writeln(f,getInt(r.flux),' ',getInt(r.rezid));
  write(f,r.getNrNoduri);
  p:=r.listaNoduri;
  while p<>nil do
  begin
    writeln(f);
    write(f,p^.index,' ',p^.x,' ',p^.y,' ',p^.d,' ',p^.e);
    p:=p^.next;
  end;
  writeln(f);
  if r.nodSursa=nil then
    write(f,0,' ')
  else
    write(f,r.nodSursa^.index,' ');
  if r.nodStoc=nil then
    write(f,0)
  else
    write(f,r.nodStoc^.index);
  a:=r.listaArce;
  while a<>nil do
  begin
    writeln(f);
    write(f,a^.x,' ',a^.y,' ',a^.l,' ',a^.c,' ',a^.f,' ',a^.r);
    a:=a^.next;
  end;
  closeFile(f);
end;

procedure TfrmMain.Open1Click(Sender: TObject);
begin
  openDialog1.FilterIndex:= 1;
  if openDialog1.Execute then
  begin
    openRetea(openDialog1.FileName);
    fisier:= opendialog1.FileName;
    tbSave.Enabled:= true;
    Save1.Enabled:= true;
    Saveas1.Enabled := true;
  end;
end;

procedure TfrmMain.Save1Click(Sender: TObject);
begin
  if fisier='' then
    begin
      saveDialog1.FilterIndex:=1;
      if saveDialog1.Execute then
        saveRetea(saveDialog1.FileName);
      fisier:= saveDialog1.FileName;
    end
  else
    saveRetea(fisier);
end;

procedure TfrmMain.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  keyD:=key;
end;

procedure TfrmMain.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 keyD:=0;
end;

function TfrmMain.getInt(x:boolean):integer;
begin
  result:=0;
  if x then
    result:=1;
end;

function TfrmMain.getBoolean(x:integer):boolean;
begin
  result:=false;
  if x=1 then
    result:=true;
end;

procedure TfrmMain.enableFluxMaxim(val:boolean);
begin
  if val then
    Algoritmi1.Enabled := true
  else
    begin
      Algoritmi1.Enabled := false;
      tbNext.Enabled := false;
      tbEnd.Enabled := false;
    end;
end;

procedure TfrmMain.legenda(val:boolean);
begin
  if val then
    begin
      label1.Visible:= true;
      image2.Visible:= true;
      updateLegenda;
    end
  else
    begin
      r.desenRetea(image1.canvas,image1.width,image1.height);
      label1.Visible:= false;
      image2.Visible:= false;
    end;
end;

procedure TfrmMain.SetNodSursaClick(Sender: TObject);
begin
  if aux<>r.nodStoc then
    r.nodSursa:= aux
  else
    showMessage('Acest nod este setat deja ca nod stoc!');
  aux:= nil;
  r.desenRetea(image1.canvas,image1.width,image1.Height);
end;

procedure TfrmMain.Stergenod1Click(Sender: TObject);
begin
   if r.nodSursa<>nil then
     if aux^.index = r.nodSursa^.index then
       r.nodSursa:= nil;
   if r.nodStoc<>nil then
     if aux^.index=r.nodStoc^.index then
       r.nodStoc:= nil;
   r.stergeNod(aux^.index);
   aux:= nil;
   n:=n-1;
   r.desenretea(image1.canvas,image1.width,image1.Height);
end;

procedure TfrmMain.Sterge1Click(Sender: TObject);
begin
  r.stergeArc(arcAux^.x,arcAux^.y);
  r.desenRetea(image1.canvas,image1.width,image1.Height);
end;

procedure TfrmMain.Modifica1Click(Sender: TObject);
begin
 openArcDialog(arcAux);
end;

procedure TfrmMain.Retea1Click(Sender: TObject);
begin
 if r=nil then
 begin
   reteaReziduala1.Enabled:=false;
   reteaNereziduala1.Enabled:=false;
 end
 else
   if r.rezid then
   begin
     tbRez.Enabled := false;
     tbFlux.Enabled := true;
     reteaReziduala1.Enabled:=false;
     reteaNereziduala1.Enabled:=true;
   end
   else
   begin
     tbRez.Enabled := true;
     tbFlux.Enabled := false;
     reteaReziduala1.Enabled:=true;
   end;
end;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  s:= '';
  fisier:= '';
  r:= TReprezentare.Create;
  r.flux:= false;
  r.rezid:= false;
  r.limit:= true;
  r.cap:= true;
  r.dist:= false;
  r.exces:= false;
  r.val:= false;
  image1.Visible:= true;
  image1.canvas.Pen.Color:=clWhite;
  image1.canvas.Rectangle(0,0,image1.width,image1.height);
  image1.canvas.Pen.Color:=clBlack;
  image1.Enabled:= false;
end;

procedure TfrmMain.FordFulkersonClick(Sender: TObject);
begin
  s:= 'FordFulkerson';
  if (r.nodSursa<>nil)and(r.nodStoc<>nil)and(r.rezid) then
    begin
      Alg.Free;
      Alg:= TFFulkerson.Create(r);
      Alg.initializare;
    end
  else
    begin
      ShowMessage('Pentru a putea determina fluxul maxim este necesara o retea reziduala in care au fost setate nodurile sursa si stoc');
      tbNext.Enabled := false;
      tbEnd.Enabled := false;
    end;
  tbNext.Enabled := true;
  tbEnd.Enabled := true;
end;

procedure TfrmMain.GenericClick(Sender: TObject);
begin
  s:= 'generic';
  if (r.nodSursa<>nil)and(r.nodStoc<>nil)and(r.rezid) then
    begin
      Alg.Free;
      Alg:= TGeneric.Create(r);
      Alg.initializare;
    end
  else
    begin
      ShowMessage('Pentru a putea determina fluxul maxim este necesara o retea reziduala in care au fost setate nodurile sursa si stoc');
      tbNext.Enabled := false;
      tbEnd.Enabled := false;
    end;
  tbNext.Enabled := true;
  tbEnd.Enabled := true;
end;

procedure TfrmMain.AhujaOrlinScalarClick(
  Sender: TObject);
begin
  s:= 'AhujaOrlinScalar';
  if (r.nodSursa<>nil)and(r.nodStoc<>nil)and(r.rezid) then
    begin
      Alg.Free;
      Alg:= TAOScMxCap.Create(r);
      Alg.initializare;
    end
  else
    begin
      ShowMessage('Pentru a putea determina fluxul maxim este necesara o retea reziduala in care au fost setate nodurile sursa si stoc');
      tbNext.Enabled := false;
      tbEnd.Enabled := false;
    end;
  tbNext.Enabled := true;
  tbEnd.Enabled := true;
end;

procedure TfrmMain.EdmondsKarpClick(
  Sender: TObject);
begin
  s:= 'EdmondsKarp';
  if (r.nodSursa<>nil)and(r.nodStoc<>nil)and(r.rezid) then
    begin
      Alg.Free;
      Alg:= TEdmondsKarp.Create(r);
      Alg.initializare;
    end
  else
    begin
      ShowMessage('Pentru a putea determina fluxul maxim este necesara o retea reziduala in care au fost setate nodurile sursa si stoc');
      tbNext.Enabled := false;
      tbEnd.Enabled := false;
    end;
  tbNext.Enabled := true;
  tbEnd.Enabled := true;
end;

procedure TfrmMain.AhujaOrlinDrumClick(
  Sender: TObject);
begin
  s:= 'AhujaOrlinDrum';
  if (r.nodSursa<>nil)and(r.nodStoc<>nil)and(r.rezid) then
    begin
      Alg.Free;
      Alg:= TAODrCMS.Create(r);
      Alg.initializare;
    end
  else
    begin
      ShowMessage('Pentru a putea determina fluxul maxim este necesara o retea reziduala in care au fost setate nodurile sursa si stoc');
      tbNext.Enabled := false;
      tbEnd.Enabled := false;
    end;
  tbNext.Enabled := true;
  tbEnd.Enabled := true;
end;

procedure TfrmMain.AhujaOrlinReteleClick(
  Sender: TObject);
begin
  s:= 'AhujaOrlinRetele';
  if (r.nodSursa<>nil)and(r.nodStoc<>nil)and(r.rezid) then
    begin
      Alg.Free;
      Alg:= TAORetStratif.Create(r);
      Alg.initializare;
    end
  else
    begin
      ShowMessage('Pentru a putea determina fluxul maxim este necesara o retea reziduala in care au fost setate nodurile sursa si stoc');
      tbNext.Enabled := false;
      tbEnd.Enabled := false;
    end;
  tbNext.Enabled := true;
  tbEnd.Enabled := true;
end;

procedure TfrmMain.PrefluxGenericClick(Sender: TObject);
begin
  s:= 'PrefluxGeneric';
  if (r.nodSursa<>nil)and(r.nodStoc<>nil)and(r.rezid) then
    begin
      Alg.Free;
      Alg:= TPrefGen.Create(r);
      Alg.initializare;
    end
  else
    begin
      ShowMessage('Pentru a putea determina fluxul maxim este necesara o retea reziduala in care au fost setate nodurile sursa si stoc');
      tbNext.Enabled := false;
      tbEnd.Enabled := false;
    end;
  tbNext.Enabled := true;
  tbEnd.Enabled := true;
end;

procedure TfrmMain.PrefluxFIFOClick(Sender: TObject);
begin
  s:= 'PrefluxFIFO';
  if (r.nodSursa<>nil)and(r.nodStoc<>nil)and(r.rezid) then
    begin
      Alg.Free;
      Alg:= TPrefFIFO.Create(r);
      Alg.initializare;
    end
  else
    begin
      ShowMessage('Pentru a putea determina fluxul maxim este necesara o retea reziduala in care au fost setate nodurile sursa si stoc');
      tbNext.Enabled := false;
      tbEnd.Enabled := false;
    end;
  tbNext.Enabled := true;
  tbEnd.Enabled := true;
end;

procedure TfrmMain.DinicClick(Sender: TObject);
begin
  s:= 'Dinic';
  if (r.nodSursa<>nil)and(r.nodStoc<>nil)and(r.rezid) then
    begin
      Alg.Free;
      Alg:= TDinicRS.Create(r);
      Alg.initializare;
    end
  else
    begin
      ShowMessage('Pentru a putea determina fluxul maxim este necesara o retea reziduala in care au fost setate nodurile sursa si stoc');
      tbNext.Enabled := false;
      tbEnd.Enabled := false;
    end;
  tbNext.Enabled := true;
  tbEnd.Enabled := true;
end;

procedure TfrmMain.GabowClick(Sender: TObject);
begin
  s:= 'gabow';
  if (r.nodSursa<>nil)and(r.nodStoc<>nil)and(r.rezid) then
    begin
      Alg.Free;
      Alg:= TGabow.Create(r);
      Alg.initializare;
    end
  else
    begin
      ShowMessage('Pentru a putea determina fluxul maxim este necesara o retea reziduala in care au fost setate nodurile sursa si stoc');
      tbNext.Enabled := false;
      tbEnd.Enabled := false;
    end;
  tbNext.Enabled := true;
  tbEnd.Enabled := true;
end;

procedure TfrmMain.SetNodStocClick(Sender: TObject);
begin
  if aux<>r.nodSursa then
    r.nodStoc:= aux
  else
    showMessage('Acest nod este setat deja ca nod stoc!');
  aux:= nil;
  r.desenRetea(image1.canvas,image1.width,image1.Height);
end;

procedure TfrmMain.Exit1Click(Sender: TObject);
begin
  r.Free;
  optiuniForm.Close;
  arcForm.Close;
  frmMain.Close;
end;

procedure TfrmMain.afiseazalegenda1Click(Sender: TObject);
begin
  afiseazalegenda1.Checked:= not afiseazalegenda1.Checked;
  legenda(afiseazalegenda1.Checked);
end;


procedure TfrmMain.Valoarenod1Click(Sender: TObject);
begin
  valoarenod1.Checked:= not (valoarenod1.Checked);
  r.val:= not r.val;
  if image2.Visible then
    updateLegenda;
  r.desenRetea(image1.canvas,image1.width,image1.Height);
end;

procedure TfrmMain.Etichetadistanta1Click(Sender: TObject);
begin
  Etichetadistanta1.Checked:= not(Etichetadistanta1.Checked);
  r.dist:= not r.dist;
  if image2.Visible then
    updateLegenda;
  r.desenRetea(image1.canvas,image1.width,image1.Height);
end;

procedure TfrmMain.Excesul1Click(Sender: TObject);
begin
  Excesul1.Checked:= not(Excesul1.Checked);
  r.exces:= not r.exces;
  if image2.Visible then
    updateLegenda;
  r.desenRetea(image1.canvas,image1.width,image1.Height);
end;

procedure TfrmMain.Capacitate2Click(Sender: TObject);
begin
  Capacitate2.Checked:= not(Capacitate2.Checked);
  r.cap:= not r.cap;
  if image2.Visible then
    updateLegenda;
  r.desenRetea(image1.canvas,image1.width,image1.Height);
end;

function TfrmMain.drumValid(drum:array of integer):boolean;
var x:integer;
begin
  result:= false;
  x:= r.nodStoc^.index;
  while (drum[x-1]<>0)and(x<>r.nodSursa^.index) do
    x:= drum[x-1];
  if x=r.nodSursa^.index then
    result:= true;
end;

procedure TfrmMain.updateLegenda;
var i,j,k:byte;
begin
  image2.canvas.Pen.Color:=ClWhite;
  image2.canvas.Rectangle(0,0,image2.width,image2.height);
  image2.canvas.Pen.Color:=ClBlack;
  image2.Canvas.TextOut(5,5,'Legenda noduri:');
  image2.Canvas.Ellipse(65,40,85,60);
  image2.Canvas.TextOut(71,43,'x');
  i:= 0;
  j:= 0;
  k:= 0;
  if r.val then
  begin
    image2.Canvas.TextOut(60,60,'v');
    i:= 1;
  end;
  if r.dist then
  begin
    image2.Canvas.TextOut(60,35,'d');
    j:= 1;
  end;
  if r.exces then
  begin
    image2.Canvas.TextOut(85,35,'e');
    k:= 1;
  end;
  image2.Canvas.TextOut(5,75,'x -> indexul');
  if i=1 then
    image2.Canvas.TextOut(5,90,'v -> valoarea');
  if j=1 then
    image2.Canvas.TextOut(5,75+(i+1)*13,'d -> eticheta distanta');
  if k=1 then
    image2.Canvas.TextOut(5,75+(i+j+1)*13,'e -> excesul');
  i:= i+j+k+2;
  image2.canvas.textOut(5,82+i*13,'Legenda arce');
  image2.Canvas.Ellipse(30,100+(i+2)*10,50,100+(i+4)*10);
  image2.canvas.textOut(36,103+(i+2)*10,'x');
  image2.Canvas.Ellipse(100,100+(i+2)*10,120,100+(i+4)*10);
  image2.Canvas.TextOut(106,103+(i+2)*10,'y');
  image2.Canvas.MoveTo(50,100+(i+3)*10);
  image2.Canvas.LineTo(100,100+(i+3)*10);
  image2.Canvas.LineTo(90,95+(i+3)*10);
  image2.Canvas.MoveTo(100,100+(i+3)*10);
  image2.Canvas.LineTo(90,105+(i+3)*10);
  j:= 100+(i+5)*10;
  i:= 0;
  if r.rezid then
  begin
    s:= 'r';
    image2.Canvas.TextOut(5,j,'r -> capacitate reziduala');
    i:= i+1;
  end
  else
  begin
    s:= 'f';
    image2.Canvas.TextOut(5,j,'f -> flux');
    if r.cap then
    begin
      s:= 'c,'+s;
      i:= i+1;
      image2.Canvas.TextOut(5,j+i*13,'c -> capacitate ');
    end;
    if r.limit then
    begin
      s:= 'l,'+s;
      i:= i+1;
      image2.Canvas.TextOut(5,j+i*13,'l -> limita inferioara');
    end;
  end;
  image2.Canvas.TextOut(57,86+(i+3)*10,s);
end;

function TfrmMain.reteaValida:boolean;
var p:nod;
begin
  result:= true;
  p:= r.listaNoduri;
  while p<>nil do
  begin
    if r.getValoareNod(p)<>0 then
      if (p^.index<>r.nodSursa^.index)and(p^.index<>r.nodStoc^.index) then
        result:= false;
    p:= p^.next;
  end;
end;

procedure TfrmMain.Saveas1Click(Sender: TObject);
begin
  saveDialog1.FilterIndex:=1;
  if saveDialog1.Execute then
    saveRetea(saveDialog1.FileName);
  fisier:= saveDialog1.FileName;
end;

procedure TFrmMain.tbRezClick(Sender: TObject);
begin
  if (r.nodSursa<>nil) and (r.nodStoc<>nil)and(reteaValida) then
    begin
      r.flux:=false;
      r.rezid:=true;
      r.makeReteaReziduala;
      tbRez.Enabled := false;
      tbFlux.Enabled := true;
      reteaReziduala1.Enabled:=false;
      reteaNereziduala1.Enabled:=true;
      enablefluxmaxim(true);
      if image2.Visible then
        updateLegenda;
      r.desenretea(image1.canvas,image1.width,image1.height);
    end
  else
    ShowMessage('Trebuie setate nodurile sursa si stoc, si celelalte noduri trebuie sa aiba valoarea 0!');
end;

procedure TFrmMain.tbFluxClick(Sender: TObject);
begin
  r.rezid:=false;
  r.flux:=true;
  r.makeReteaNereziduala;
  tbRez.Enabled := true;
  tbFlux.Enabled := false;
  reteaReziduala1.Enabled:=true;
  reteaNereziduala1.Enabled:=false;
  enablefluxmaxim(false);
  if image2.Visible then
    updateLegenda;
  r.desenRetea(image1.canvas,image1.width,image1.Height);
end;

procedure TFrmMain.tbNextClick(Sender: TObject);
begin
  if s<>'' then
  begin
    if Alg.existaContinuare then
    begin
      r.desenRetea(image1.canvas,image1.width,image1.Height);
      Alg.FluxMaximStep;
      if (Alg.drum<>nil) then
      begin
        if (drumValid(Alg.drum)) then
          r.desenDrum(Alg.drum,clRed,image1.Canvas);
      end
      else
        r.desenRetea(image1.canvas,image1.width,image1.Height);
    end
    else
    begin
      tbNext.Enabled := false;
      tbEnd.Enabled := false;
      s:='';
      r.desenRetea(image1.canvas,image1.width,image1.Height);
    end;
  end
  else
    showmessage('Mai intai trebuie ales un algoritm!');
end;

procedure TFrmMain.tbEndClick(Sender: TObject);
begin
  if s<>'' then
  begin
    Alg.FluxMaximEnd;
    r.desenRetea(image1.canvas,image1.width,image1.Height);
    tbNext.Enabled := false;
    tbEnd.Enabled := false;
    s:='';
  end
  else
    showmessage('Mai intai trebuie ales un algoritm!');
end;

procedure TFrmMain.Des1Click(Sender: TObject);
begin
  AboutBox.Show;
end;

end.
