unit ReprezentareRetea;

interface
uses   Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
       Dialogs, ExtCtrls, ToolWin, ComCtrls, StdCtrls, Retea;
type
  TReprezentare=class(TRetea)
                    flux, rezid, limit, cap, dist, exces, val:boolean;
                    procedure desenNod(index,x,y:integer;cul:TColor;zona:TCanvas);overload;
                    procedure desenNod(p:nod;cul:TColor;zona:TCanvas);overload;
                    procedure desenNod(p:nod;culInt,culExt:TColor;zona:TCanvas);overload;
                    procedure desenArc(nodP,nodU:integer;cul:TColor;zona:TCanvas);
                    procedure desenDrum(drum:array of integer; cul:TColor; zona:TCanvas);
                    procedure desenRetea(zona:TCanvas;w,h:integer);//w->latimea zonei, h->inaltimea zonei
                  private
                    procedure calcPoz(x1,y1,x2,y2,d:integer;prim:boolean;var x,y:integer);
                end;
implementation

procedure TReprezentare.desenNod(index,x,y:integer;cul:TColor;zona:TCanvas);
var s:string;
begin
  zona.pen.color:=cul;
  str(index,s);
  zona.Ellipse(x,y,x+20,y+20);
  if (index<10) then
    zona.TextOut(x+6,y+3,s)
  else
    zona.TextOut(x+4,y+3,s);
  zona.pen.color:=clBlack;
  if val then
  begin
    str(getValoareNod(index),s);
    zona.TextOut(x-5,y+20,s);
  end;
  if dist then
  begin
    str(getNod(index)^.d,s);
    zona.TextOut(x-5,y-5,s);
  end;
  if exces then
  begin
    str(getNod(index)^.e,s);
    zona.TextOut(x+20,y-5,s);
  end;
end;

procedure TReprezentare.desenNod(p:nod;cul:TColor;zona:TCanvas);
var s:string;
begin
  zona.pen.color:=cul;
  str(p^.index,s);
  zona.Ellipse(p^.x,p^.y,p^.x+20,p^.y+20);
  if (p^.index<10) then
    zona.TextOut(p^.x+6,p^.y+3,s)
  else
    zona.TextOut(p^.x+4,p^.y+3,s);
  zona.Pen.Color:=clblack;
  if val then
  begin
    str(getValoareNod(p),s);
    zona.TextOut(p^.x-5,p^.y+20,s);
  end;
  if dist then
  begin
    str(p^.d,s);
    zona.TextOut(p^.x-5,p^.y-5,s);
  end;
  if exces then
  begin
    str(p^.e,s);
    zona.TextOut(p^.x+20,p^.y-5,s);
  end;
end;

procedure TReprezentare.desenNod(p:nod;culInt,culExt:TColor;zona:TCanvas);
var s:string;
begin
  zona.pen.color:=culExt;
  zona.Brush.Color:=culInt;
  str(p^.index,s);
  zona.Ellipse(p^.x,p^.y,p^.x+20,p^.y+20);
  zona.FloodFill(p^.x+10,p^.y+10,culExt,fsBorder);
  if (p^.index<10) then
    zona.TextOut(p^.x+6,p^.y+3,s)
  else
    zona.TextOut(p^.x+4,p^.y+3,s);
  zona.Brush.Color:= clwhite;
  zona.Pen.Color:=clblack;
  if val then
  begin
    str(getValoareNod(p),s);
    zona.TextOut(p^.x-5,p^.y+20,s);
  end;
  if dist then
  begin
    str(p^.d,s);
    zona.TextOut(p^.x-5,p^.y-5,s);
  end;
  if exces then
  begin
    str(p^.e,s);
    zona.TextOut(p^.x+20,p^.y-5,s);
  end;
end;

procedure TReprezentare.desenArc(nodP,nodU:integer;cul:TColor;zona:TCanvas);
var p,q:nod;
    alfa:real;
    x,y,x1,y1,x2,y2,xi,yi:integer;
    s,s1:string;
begin
 zona.pen.color:=cul;
 p:=getNod(nodP);
 q:=getNod(nodU);
 s:='';
 if flux then
 begin
   if cap then
   begin
     str(getArc(p,q)^.c,s1);
     s:=s+s1+',';
   end;
   str(getArc(p,q)^.f,s1);
   s:=s+s1;
 end
 else
   if rezid then
   begin
     str(getArc(p,q)^.r,s1);
     s:=s+s1;
   end;
 calcPoz(p^.x+10,p^.y+10,q^.x+10,q^.y+10,5,true,x,y);
 xi:=x;
 yi:=y;
 zona.MoveTo(x,y);
 calcPoz(p^.x+10,p^.y+10,q^.x+10,q^.y+10,5,false,x,y);
 zona.LineTo(x,y);
 x1:=(xi+2*x) div 3-5-(length(s)div 2*4);
 y1:=(yi+2*y) div 3-5;
 zona.TextOut(x1,y1,s);
 x1:=x;
 y1:=y;
 calcPoz(p^.x+10,p^.y+10,q^.x+10,q^.y+10,14,false,x,y);
 x2:=x;
 y2:=y;
 alfa:=-Pi/2;
 x:=trunc(x1+(x2-x1)*cos(alfa)-(y2-y1)*sin(alfa));
 y:=trunc(y1+(x2-x1)*sin(alfa)+(y2-y1)*cos(alfa));
 //Prima sageata
 x1:=x;
 y1:=y;
 zona.MoveTo(x1,y1);
 calcPoz(xi,yi,x1,y1,10,false,x,y);
 x2:=x;
 y2:=y;
 alfa:=-Pi/4;
 x:=trunc(x1+(x2-x1)*cos(alfa)-(y2-y1)*sin(alfa));
 y:=trunc(y1+(x2-x1)*sin(alfa)+(y2-y1)*cos(alfa));
 zona.LineTo(x,y);
 //A doua sageata
 zona.MoveTo(x1,y1);
 alfa:=-3*Pi/4;
 x:=trunc(x1+(x2-x1)*cos(alfa)-(y2-y1)*sin(alfa));
 y:=trunc(y1+(x2-x1)*sin(alfa)+(y2-y1)*cos(alfa));
 zona.LineTo(x,y);
 zona.Pen.Color:=clblack;
 if (p=nodSursa) then
   desenNod(p,rgb(253,220,206),rgb(5,5,124),zona)
 else if (p=nodStoc) then
        desenNod(p,rgb(233,128,82),rgb(5,5,124),zona)
      else
        desenNod(p,clBlack,zona);
 if (q=nodSursa) then
   desenNod(q,rgb(253,220,206),rgb(5,5,124),zona)
 else if (q=nodStoc) then
        desenNod(q,rgb(233,128,82),rgb(5,5,124),zona)
      else
        desenNod(q,clBlack,zona);
end;

procedure TReprezentare.desenDrum(drum:array of integer; cul:TColor; zona:TCanvas);
var x:integer;
begin
 x:= nodStoc^.index;
 while x<>nodSursa^.index do
 begin
   desenArc(drum[x-1],x,clRed,zona);
   desenArc(x,drum[x-1],clRed,zona);
   x:= drum[x-1];
 end;
end;

procedure TReprezentare.desenRetea(zona:TCanvas;w,h:integer);
var p:nod;
    a:arc;
begin
  //Se sterge imaginea anterioara prin desenarea unui dreptunghi alb pe intreaga
  //suprafata a imaginii
  zona.Pen.Color:=ClWhite;
  zona.Rectangle(0,0,w,h);
  zona.Pen.Color:=ClBlack;
  //Se deseneaza arcele
  a:=listaArce;
  while (a<>nil) do
  begin
    if rezid then
    begin
      if (a^.r>0) then
        desenArc(a^.x,a^.y,clBlack,zona)
    end
    else
      if (a^.c>0) then
        desenArc(a^.x,a^.y,clBlack,zona);
    a:=a^.next;
  end;
  //Se deseneaza nodurile
  p:= listaNoduri;
  while (p<>nil) do
  begin
    if (p=nodSursa) then
      desenNod(p,rgb(253,220,206),rgb(5,5,124),zona)
    else
      if (p=nodStoc) then
        desenNod(p,rgb(233,128,82),rgb(5,5,124),zona)
      else
        desenNod(p,clBlack,zona);
    p:=p^.next;
  end;
end;

procedure TReprezentare.calcPoz(x1,y1,x2,y2,d:integer;prim:boolean;var x,y:integer);
var m,alfa:real;
begin
 if ((y2-y1)<>0) then
   m:=(x1-x2)/(y2-y1)
  else
   m:=x1-x2;
 if prim then
  begin
   x:=x1;
   y:=y1;
  end
 else
  begin
   x:=x2;
   y:=y2;
  end;
 if (y1<=y2) then
  begin
   alfa := PI - arctan(m);
   x:=trunc(x-d*cos(alfa));
   y:=trunc(y+d*sin(alfa));
  end
 else
  begin
   x:=trunc(x-d*cos(arctan(m)));
   y:=trunc(y-d*sin(arctan(m)));
  end;
end;

end.
