unit Retea;

interface

uses  Math,Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ComCtrls, ScktComp;

type
   Nod=^elem;
   elem=record
           index:integer;
           x,y:integer;  //coordonatele
           d,e:integer;  //eticheta distanta si exces
           next:nod;
         end;

   Arc=^inreg;
   inreg=record
           x,y:integer;
           l,c,r,f:integer;
           next:arc;
         end;

   TRetea= class(TObject)
             nodSursa,nodStoc:nod;
             listaNoduri:nod;
             listaArce:arc;
             procedure adaugaNod(index,x,y:integer);overload;
             procedure adaugaNod(index,x,y,d,e:integer);overload;
             procedure adaugaArc(x,y:integer);overload;
             procedure adaugaArc(x,y,l,c,f,r:integer);overload;
             procedure stergeNod(index:integer);
             procedure stergeArc(x,y:integer);overload;
             procedure stergeArc(a:arc);overload;
             procedure modificaNod(x,d:integer);overload;
             procedure modificaNod(x,d,e:integer);overload;
             procedure modificaNod(x,y,d,e:integer);overload;
             procedure modificaArc(x,y,c,fr,tag:integer);overload;
             procedure mutaNod(p:nod;x,y:integer);
             procedure eliminareIndex(index:integer);
             procedure modifIndexi;
             procedure makeReteaReziduala;
             procedure makeReteaNereziduala;
             function nodValid(x,y:integer):boolean;
             function getNod(index:integer):nod;overload;
             function getNod(x,y:integer):nod;overload;
             function existaNod(x,y:integer):boolean;
             function getArc(p,q:nod):arc;overload;
             function getArc(x,y:integer):arc;overload;
             function existaArc(p,q:nod):boolean;
             function getNrNoduri:integer;
             function getNrArce:integer;
             function getValoareNod(p:nod):integer;overload;
             function getValoareNod(x:integer):integer;overload;
           end;

implementation

procedure TRetea.adaugaNod(index,x,y:integer);
var p,q:nod;
begin
 new(p);
 p^.index:=index;
 p^.x:=x;
 p^.y:=y;
 p^.d:=0;
 p^.e:=0;
 p^.next:=nil;
 if listaNoduri=nil then
  listaNoduri:=p
 else
  begin
   q:=listaNoduri;
   while q^.next<>nil do q:=q^.next;
   q^.next:=p;
  end;
end;

procedure TRetea.adaugaNod(index,x,y,d,e:integer);
var p,q:nod;
begin
 new(p);
 p^.index:=index;
 p^.x:=x;
 p^.y:=y;
 p^.d:=d;
 p^.e:=e;
 p^.next:=nil;
 if listaNoduri=nil then
  listaNoduri:=p
 else
  begin
   q:=listaNoduri;
   while q^.next<>nil do q:=q^.next;
   q^.next:=p;
  end;
end;

procedure TRetea.adaugaArc(x,y:integer);
var a,b:arc;
begin
 new(a);
 a^.x:=x;
 a^.y:=y;
 a^.l:=0;
 a^.c:=0;
 a^.f:=0;
 a^.r:=0;
 a^.next:=nil;
 if listaArce=nil then
  listaArce:=a
 else
  begin
   b:=listaArce;
   while b^.next<>nil do b:=b^.next;
   b^.next:=a;
  end;
end;

procedure TRetea.adaugaArc(x,y,l,c,f,r:integer);
var a,b:arc;
begin
 new(a);
 a^.x:=x;
 a^.y:=y;
 a^.l:=l;
 a^.c:=c;
 a^.f:=f;
 a^.r:=r;
 a^.next:=nil;
 if listaArce=nil then
  listaArce:=a
 else
  begin
   b:=listaArce;
   while b^.next<>nil do b:=b^.next;
   b^.next:=a;
  end;
end;

procedure TRetea.stergeArc(x,y:integer);
var a,b:arc;
begin
 a:=listaArce;
 b:=nil;
 while a<>nil do
   if ((a^.x=x) and (a^.y=y)) then
    begin
     if b<>nil then
       b^.next:=a^.next
     else listaArce:=a^.next;
     a:=nil;
    end
   else
    begin
     b:=a;
     a:=a^.next;
    end;
end;

procedure TRetea.stergeArc(a:arc);
var ar,b:arc;
begin
 ar:=listaArce;
 b:=nil;
 while ar<>nil do
   if a=ar then
   begin
     if b<>nil then
       b^.next:=ar^.next
     else listaArce:=ar^.next;
     ar:=nil;
   end
   else
   begin
     b:=ar;
     ar:=ar^.next;
   end;
end;

procedure TRetea.stergeNod(index:integer);
var p,q:nod;
    a:arc;
begin
 p:=listaNoduri;
 q:=nil;
 while p<>nil do
   if (p^.index=index) then
    begin
     if p=listaNoduri then
      listaNoduri:=listaNoduri^.next
     else
      q^.next:=p^.next;
     p:=nil;
    end
   else
    begin
     q:=p;
     p:=p^.next;
    end;
  a:=listaArce;
  while a<>nil do
  begin
    if(a^.x=index)or(a^.y=index) then
      StergeArc(a^.x,a^.y);
    a:=a^.next;
  end;
  eliminareIndex(index);
end;

procedure TRetea.mutaNod(p:nod;x,y:integer);
var q:nod;
begin
 q:=listaNoduri;
 while q<>nil do
  if((p^.x=q^.x)and(p^.y=q^.y))then
   begin
    q^.x:=x;
    q^.y:=y;
    q:=nil;
   end
  else
   q:=q^.next;
end;

procedure TRetea.modificaArc(x,y,c,fr,tag:integer);
var a:arc;
begin
  a:=listaArce;
  if tag=0 then
    begin
    while a<>nil do
      if(a^.x=x)and(a^.y=y) then
        begin
          a^.c:=c;
          a^.f:=fr;
          a:=nil;
        end
      else
        a:=a^.next;
    end
  else
    begin
    while a<>nil do
      if(a^.x=x)and(a^.y=y) then
        begin
          a^.c:=c;
          a^.r:=fr;
          a:=nil;
        end
      else
        a:=a^.next;
    end;
end;

procedure TRetea.modificaNod(x,d:integer);
var p:nod;
begin
 p:=listaNoduri;
 while p<>nil do
  if(p^.index=x) then
   begin
    p^.d:=d;
    p:=nil;
   end
  else
   p:=p^.next;
end;

procedure TRetea.modificaNod(x,d,e:integer);
var p:nod;
begin
 p:=listaNoduri;
 while p<>nil do
  if(p^.index=x) then
   begin
    p^.d:=d;
    p^.e:=e;
    p:=nil;
   end
  else
   p:=p^.next;
end;

procedure TRetea.modificaNod(x,y,d,e:integer);
var p:nod;
begin
 p:=listaNoduri;
 while p<>nil do
  if(p^.x=x)and(p^.y=y) then
   begin
    p^.d:=d;
    p^.e:=e;
    p:=nil;
   end
  else
   p:=p^.next;
end;

procedure TRetea.eliminareIndex(index:integer);
var p:nod;
    a:arc;
begin
 p:=listaNoduri;
 while p<>nil do
 begin
   if (p^.index>index) then
     p^.index:=p^.index-1;
   p:=p^.next;
 end;
 a:=listaArce;
 while a<>nil do
 begin
   if (a^.x>index) then
     a^.x:=a^.x-1;
   if (a^.y>index) then
     a^.y:=a^.y-1;
   a:=a^.next;
 end;
end;

procedure TRetea.makeReteaReziduala;
var a,aux:arc;
    cr:integer;
begin
 a:=listaArce;
 while a<>nil do
 begin
   aux:=getArc(a^.y,a^.x);
   if aux<>nil then
     cr := a^.c - a^.f + aux^.f
   else
    begin
     cr := a^.c - a^.f;
     adaugaArc(a^.y,a^.x);
    end;
   modificaArc(a^.x,a^.y,a^.c,cr,1);
   a:=a^.next;
 end;
end;

procedure TRetea.makeReteaNereziduala;
var a,aux:arc;
    val:integer;
begin
  a:=listaArce;
  while a<>nil do
  begin
    val:=a^.c - a^.r;
    aux:= getArc(a^.y,a^.x);
    if aux<>nil then
     if val>=0 then
      begin
       a^.f:=val;
       aux^.f := 0;
      end
     else
      begin
        a^.f:=0;
        aux^.f := -val;
      end;
    a:=a^.next;
  end;
end;

procedure TRetea.modifIndexi;
var p:nod;
    a:arc;
begin
  p:= listaNoduri;
  while p<>nil do
  begin
    p^.index:= p^.index+1;
    p:= p^.next;
  end;
  a:= listaArce;
  while a<>nil do
  begin
    a^.x:= a^.x+1;
    a^.y:= a^.y+1;
    a:= a^.next;
  end;
end;

function TRetea.nodValid(x,y:integer):boolean;
var p:nod;
    d:integer;
begin
 result:=true;
 p:=listaNoduri;
 while p<>nil do
  begin
   d:=trunc(sqrt(sqr(p.x-x)+sqr(p.y-y)));
   if (d<22) then
    begin
     result:=false;
     p:=nil;
    end
   else
    p:=p^.next;
  end;
end;

function TRetea.getNod(index:integer):nod;
var p:nod;
begin
 result:=nil;
 p:=listaNoduri;
 while p<>nil do
  if (p^.index=index) then
   begin
    result:=p;
    p:=nil;
   end
  else
   p:=p^.next;
end;

function TRetea.getNod(x,y:integer):nod;
var p:nod;
begin
 result:=nil;
 p:=listaNoduri;
 while p<>nil do
  if ((x-p^.x<=20)and(x-p^.x>=0)and(y-p^.y<=20)and(y-p^.y>=0)) then
   begin
    result:=p;
    p:=nil;
   end
  else
   p:=p^.next;
end;

function TRetea.existaNod(x,y:integer):boolean;
var p:nod;
begin
 result:=false;
 p:=listaNoduri;
 while p<>nil do
  if ((x-p^.x<=20)and(x-p^.x>=0)and(y-p^.y<=20)and(y-p^.y>=0)) then
   begin
    result:=true;
    p:=nil;
   end
  else
   p:=p^.next;
end;

function TRetea.getArc(p,q:nod):arc;
var a:arc;
begin
 result:=nil;
 a:=listaArce;
 while a<>nil do
  if(a^.x=p^.index)and(a^.y=q^.index) then
   begin
    result:=a;
    a:=nil;
   end
  else
   a:=a^.next;
end;

function TRetea.getArc(x,y:integer):arc;
var a:arc;
begin
 result:=nil;
 a:=listaArce;
 while a<>nil do
  if(a^.x=x)and(a^.y=y) then
   begin
    result:=a;
    a:=nil;
   end
  else
   a:=a^.next;
end;

function TRetea.existaArc(p,q:nod):boolean;
var a:arc;
begin
 result:=false;
 a:=listaArce;
 while a<>nil do
  if(a^.x=p^.index)and(a^.y=q^.index) then
   begin
    result:=true;
    a:=nil;
   end
  else
   a:=a^.next;
end;

function TRetea.getNrNoduri:integer;
var p:nod;
begin
  result:=0;
  p:=listaNoduri;
  while p<>nil do
  begin
    result:=result+1;
    p:=p^.next;
  end;
end;

function TRetea.getNrArce:integer;
var a:arc;
begin
  result:=0;
  a:=listaArce;
  while a<>nil do
  begin
    result:=result+1;
    a:=a^.next;
  end;
end;

function TRetea.getValoareNod(p:nod):integer;
var a:arc;
    v:integer;
begin
  v:= 0;
  a:= listaArce;
  while a<>nil do
  begin
    if a^.x=p^.index then
      v:= v+a^.f
    else
      if a^.y=p^.index then
        v:= v-a^.f;
    a:= a^.next;
  end;
  result:= v;
end;

function TRetea.getValoareNod(x:integer):integer;
var a:arc;
    v:integer;
begin
  v:= 0;
  a:= listaArce;
  while a<>nil do
  begin
    if a^.x=x then
      v:= v+a^.f
    else
      if a^.y=x then
        v:= v-a^.f;
    a:= a^.next;
  end;
  result:= v;
end;

end.

