unit arcDialog;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, StdCtrls, ProiectAOC;

type
  TarcForm = class(TForm)
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    limitaInf: TEdit;
    capacitate: TEdit;
    fluxul: TEdit;
    capRezid: TEdit;
    butOk: TSpeedButton;
    butCancel: TSpeedButton;
    aldoileaN: TEdit;
    primulN: TEdit;
    procedure butOkClick(Sender: TObject);
    procedure butCancelClick(Sender: TObject);
    procedure capacitateKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure fluxulKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure capRezidKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormShow(Sender: TObject);
  private
    function valid(limita,cap,flux,caprez:integer):boolean;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  arcForm: TarcForm;

implementation

{$R *.DFM}

function TarcForm.valid(limita,cap,flux,caprez:integer):boolean;
var s:string;
begin
  result:=true;
  s:= '';
  if cap=0 then
    begin
      result:=false;
      s:= s+'Capacitatea trebuie sa fie mai mare decat 0!' + #13#10;
    end;
  if (frmMain.r.rezid) and (caprez=0) then
  begin
    result:=false;
    s:= s+'Capacitatea reziduala trebuie sa fie mai mare decat 0!' + #13#10;
  end;
  if cap<limita then
  begin
    result:=false;
    s:= s+'Capacitatea trebuie sa fie mai mare decat limita inferioara!' + #13#10;
  end;
  if cap < flux then
  begin
    result := false;
    s := s + 'Capacitatea trebuie sa fie mai mare decat fluxul!';
  end;
  if s <> '' then
    ShowMessage(s);
end;

procedure TarcForm.butOkClick(Sender: TObject);
var x,y,l,c,cod,cr,f:integer;
begin
  val(primulN.text,x,cod);
  val(aldoileaN.text,y,cod);
  val(limitaInf.text,l,cod);
  val(capacitate.text,c,cod);
  val(fluxul.text,f,cod);
  val(capRezid.text,cr,cod);
  if valid(l,c,f,cr) then
  begin
    if frmMain.r.rezid then
      frmMain.r.modificaArc(x,y,c,cr,1)
    else
      frmMain.r.modificaArc(x,y,c,f,0);
    arcForm.Visible:=false;
    frmMain.r.desenRetea(frmMain.Image1.Canvas,frmMain.Image1.Width,frmMain.Image1.Height);
    frmMain.Enabled:=true;
    frmMain.SetFocus;
  end;
end;


procedure TarcForm.butCancelClick(Sender: TObject);
begin
   arcForm.Visible:=false;
   frmMain.r.desenRetea(frmMain.Image1.Canvas,frmMain.Image1.Width,frmMain.Image1.Height);
   frmMain.Enabled:=true;
   frmMain.SetFocus;
end;

procedure TarcForm.capacitateKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_RETURN then
    if fluxul.Enabled then
      fluxul.SetFocus
    else if capRezid.Enabled then
            capRezid.SetFocus;
  if Key = VK_ESCAPE then
    butCancelClick(Sender);
end;

procedure TarcForm.fluxulKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_RETURN then
    butOkClick(Sender);
  if Key = VK_ESCAPE then
    butCancelClick(Sender);
end;

procedure TarcForm.capRezidKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_RETURN then
    butOkClick(Sender);
  if Key = VK_ESCAPE then
    butCancelClick(Sender);
end;

procedure TarcForm.FormShow(Sender: TObject);
begin
  capacitate.SetFocus;
end;

end.
